/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Launcher {
    private boolean stateVerbose = false;
    private List myClassPathEntries = new ArrayList();
    private List myApplicationParameters = new ArrayList();
    private Map myVirtualMachineProperties = new HashMap();
    private String myApplicationClassName = null;
    private String myApplicationMethodName = "main";
    private Document myConfigurationDocument = null;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) throws Throwable {
        File configurationFile = Launcher.findXmlConfigurationFile(args);
        if (!configurationFile.exists()) {
            throw new IllegalArgumentException("No configuration file existent at: " + configurationFile);
        }
        Launcher launcher = new Launcher(configurationFile);
        launcher.initialize();
        launcher.execute();
    }

    public Launcher(File configurationFile) throws IOException {
        BufferedReader fileReader = new BufferedReader(new FileReader(configurationFile));
        StringBuffer fileContent = new StringBuffer();
        String line = fileReader.readLine();
        while (line != null) {
            fileContent.append(line).append('\n');
            line = fileReader.readLine();
        }
        String xmlSourceString = fileContent.toString();
        File currentDirectory = new File(".").getCanonicalFile();
        xmlSourceString = xmlSourceString.replaceAll("\\$\\{launcherDirectory}", currentDirectory.getAbsolutePath());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        StringReader xmlSourceReader = new StringReader(xmlSourceString);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDocument = db.parse(new InputSource(xmlSourceReader));
            this.setConfigurationDocument(xmlDocument);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot initalize XML parser");
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("XML configuration file has an illegal format: " + e.getMessage());
        }
    }

    protected static File findXmlConfigurationFile(String[] arguments) {
        if (arguments == null || arguments.length < 1) {
            return new File("launcher.prefs.xml");
        }
        return new File(arguments[0]);
    }

    protected ClassLoader createClassLoader() {
        List urlList = this.getClassPathEntries();
        URL[] urlArray = new URL[urlList.size()];
        urlList.toArray(urlArray);
        URLClassLoader loader = new URLClassLoader(urlArray, this.getClass().getClassLoader());
        return loader;
    }

    public void initialize() throws IOException {
        Element xmlElement = this.getConfigurationDocument().getDocumentElement();
        String verbose = xmlElement.getAttribute("verbose");
        if (verbose != null && verbose.length() > 0 && verbose.equalsIgnoreCase("true")) {
            this.setVerbose(true);
        }
        NodeList xmlElements = xmlElement.getChildNodes();
        int i = 0;
        while (i < xmlElements.getLength()) {
            Node xmlNode = xmlElements.item(i);
            if (xmlNode.getNodeType() == 1) {
                String nodeName = xmlNode.getNodeName().toLowerCase();
                if (nodeName.equals("classpath")) {
                    this.initializeClasspath((Element)xmlNode);
                } else if (nodeName.equalsIgnoreCase("application")) {
                    this.initializeApplication((Element)xmlNode);
                } else if (nodeName.equalsIgnoreCase("vm")) {
                    this.initializeVM((Element)xmlNode);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeClasspath(Element xmlElement) throws IOException {
        NodeList subNodes = xmlElement.getChildNodes();
        File currentDirectory = new File(".").getCanonicalFile();
        String base = xmlElement.getAttribute("base");
        if (base != null && base.length() > 0) {
            currentDirectory = new File(currentDirectory, base);
        }
        int i = 0;
        while (i < subNodes.getLength()) {
            block7: {
                String location;
                String subNodeName;
                Element subElement;
                block8: {
                    String url;
                    block9: {
                        Node subNode = subNodes.item(i);
                        if (subNode.getNodeType() != 1) break block7;
                        subElement = (Element)subNode;
                        subNodeName = subNode.getNodeName().toLowerCase();
                        if (!subNodeName.equals("lib")) break block8;
                        location = subElement.getAttribute("location");
                        url = subElement.getAttribute("url");
                        if (location == null || location.length() <= 0) break block9;
                        File libFile = new File(currentDirectory, location).getCanonicalFile();
                        URL libURL = libFile.toURL();
                        this.getClassPathEntries().add(libURL);
                        if (this.isVerbose()) {
                            System.out.println("- Add LibFile: " + libFile.getCanonicalPath());
                        }
                        break block7;
                    }
                    if (url == null || url.length() <= 0) throw new IllegalArgumentException("Entry 'lib' must contain 'location' or 'url' attribute");
                    URL libURL = new URL(url);
                    if (!this.isVerbose()) break block7;
                    System.out.println("- Add LibURL:  " + libURL);
                    break block7;
                }
                if (subNodeName.equals("libdirectory")) {
                    location = subElement.getAttribute("location");
                    if (location == null || location.length() <= 0) throw new IllegalArgumentException("Entry 'libdirectory' must contain 'location' attribute");
                    File libDirectory = new File(currentDirectory, location);
                    File[] libFiles = libDirectory.listFiles();
                    if (libFiles != null && libFiles.length > 0) {
                        int j = 0;
                        while (j < libFiles.length) {
                            if (this.isVerbose()) {
                                System.out.println("- Add LibFile: " + libFiles[j].getCanonicalPath());
                            }
                            this.getClassPathEntries().add(libFiles[j].getCanonicalFile().toURL());
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void initializeApplication(Element xmlElement) {
        String className = xmlElement.getAttribute("class");
        String methodName = xmlElement.getAttribute("method");
        if (className == null || className.length() < 1) {
            throw new IllegalArgumentException("No main class specified");
        }
        this.setApplicationClassName(className);
        if (this.isVerbose()) {
            System.out.println("- Set main class: " + className);
        }
        if (methodName != null && methodName.length() > 0) {
            if (this.isVerbose()) {
                System.out.println("- Set entry method: " + methodName);
            }
            this.setApplicationMethodName(methodName);
        }
        NodeList children = xmlElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 1 && currentNode.getNodeName().equalsIgnoreCase("argument")) {
                Element currentElement = (Element)currentNode;
                String currentValue = currentElement.getAttribute("value");
                if (this.isVerbose()) {
                    System.out.println("- Set Parameter: '" + currentValue + "'");
                }
                this.getApplicationParameters().add(currentValue);
            }
            ++i;
        }
    }

    protected void initializeVM(Element xmlElement) {
        NodeList children = xmlElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 1 && currentNode.getNodeName().equalsIgnoreCase("property")) {
                Element currentElement = (Element)currentNode;
                this.getVirtualMachineProperties().put(currentElement.getAttribute("name"), currentElement.getAttribute("value"));
                if (this.isVerbose()) {
                    System.out.println("- Set SysProperty: '" + currentElement.getAttribute("name") + "' = '" + currentElement.getAttribute("value") + "'");
                }
            }
            ++i;
        }
    }

    public void execute() throws Throwable {
        String className = this.getApplicationClassName();
        String methodName = this.getApplicationMethodName();
        try {
            System.getProperties().putAll((Map<?, ?>)this.getVirtualMachineProperties());
            ClassLoader classLoader = this.createClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = classLoader.loadClass(className);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method mainMethod = mainClass.getMethod(methodName, classArray);
            List parameterList = this.getApplicationParameters();
            String[] parameterArray = new String[parameterList.size()];
            parameterList.toArray(parameterArray);
            mainMethod.invoke(null, new Object[]{parameterArray});
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Cannot find application main class: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException("Application main class is not accessible: " + className);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("Cannot find application entry method: " + methodName + " [" + e.getMessage() + "]");
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected List getClassPathEntries() {
        return this.myClassPathEntries;
    }

    protected List getApplicationParameters() {
        return this.myApplicationParameters;
    }

    protected Map getVirtualMachineProperties() {
        return this.myVirtualMachineProperties;
    }

    protected void setApplicationClassName(String className) {
        this.myApplicationClassName = className;
    }

    protected String getApplicationClassName() {
        return this.myApplicationClassName;
    }

    protected void setApplicationMethodName(String methodName) {
        this.myApplicationMethodName = methodName;
    }

    protected String getApplicationMethodName() {
        return this.myApplicationMethodName;
    }

    protected void setConfigurationDocument(Document document) {
        this.myConfigurationDocument = document;
    }

    protected Document getConfigurationDocument() {
        return this.myConfigurationDocument;
    }

    protected void setVerbose(boolean state) {
        this.stateVerbose = state;
    }

    protected boolean isVerbose() {
        return this.stateVerbose;
    }
}

