/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2;

import java.net.URL;
import org.jperdian.rss2.RssException;
import org.jperdian.rss2.RssParser;
import org.jperdian.rss2.dom.RssChannel;

public class RssClient {
    private RssParser myParser = new RssParser();
    private URL myURL = null;
    private String myKeywords = "";
    private String myTitle = "";

    public RssClient(URL url) {
        this(url, "", "");
    }

    public RssClient(URL url, String keywords, String title) {
        this.setURL(url);
        this.setKeywords(keywords);
        this.setTitle(title);
    }

    public final RssChannel getData() throws RssException {
        RssChannel channel = new RssChannel(this);
        channel.setClient(this);
        this.loadData(channel);
        return channel;
    }

    public void loadData(RssChannel channel) throws RssException {
        this.getParser().parse(this.getURL(), channel);
        channel.setDataLoaded(true);
        channel.setLastUpdate(System.currentTimeMillis());
    }

    protected RssParser getParser() {
        return this.myParser;
    }

    protected void setURL(URL url) {
        this.myURL = url;
    }

    public URL getURL() {
        return this.myURL;
    }

    protected void setKeywords(String keywords) {
        this.myKeywords = keywords;
    }

    public String getKeywords() {
        return this.myKeywords;
    }

    protected void setTitle(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }
}

