/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class RssHelper {
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("#,##0");
    private static final NumberFormat FLOAT_FORMAT = new DecimalFormat("#,##0.0");
    private static final Component DUMMY_COMP = new JLabel();
    private static final String TEXT_START = "org/jperdian/rss2/res/texts/";
    private static final String RESOURCE_START = "org/jperdian/rss2/res/images/";
    static /* synthetic */ Class class$0;

    public static String getResourceText(String imageName) {
        ClassLoader loader;
        URL resourceURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.jperdian.rss2.RssHelper;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resourceURL = (loader = clazz.getClassLoader()).getResource(TEXT_START + imageName)) == null) {
            throw new IllegalArgumentException("Cannot find text resource: org/jperdian/rss2/res/texts/" + imageName);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream()));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line).append('\n');
                line = reader.readLine();
            }
            return buffer.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static Icon getResourceImageIcon(String imageName) {
        ClassLoader loader;
        URL resourceURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.jperdian.rss2.RssHelper;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resourceURL = (loader = clazz.getClassLoader()).getResource(RESOURCE_START + imageName)) == null) {
            throw new IllegalArgumentException("Cannot find image resource: org/jperdian/rss2/res/images/" + imageName);
        }
        return new ImageIcon(resourceURL);
    }

    public static Image getResourceImage(String imageName) {
        ClassLoader loader;
        URL resourceURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.jperdian.rss2.RssHelper;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resourceURL = (loader = clazz.getClassLoader()).getResource(RESOURCE_START + imageName)) == null) {
            throw new IllegalArgumentException("Cannot find image resource: org/jperdian/rss2/res/images/" + imageName);
        }
        Image img = Toolkit.getDefaultToolkit().createImage(resourceURL);
        MediaTracker imgTracker = new MediaTracker(DUMMY_COMP);
        imgTracker.addImage(img, 0);
        try {
            imgTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static Image getImage(File file) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        return RssHelper.waitFor(image);
    }

    public static Image scaleImageProportional(Image sourceImage, Dimension maxDimension, boolean highQuality) {
        double targetWidth = maxDimension.width;
        double targetHeight = maxDimension.height;
        double currentWidth = sourceImage.getWidth(DUMMY_COMP);
        double currentHeight = sourceImage.getHeight(DUMMY_COMP);
        if (currentWidth > targetWidth || currentHeight > targetHeight) {
            double scaleX = 1.0 / currentWidth * targetWidth;
            double scaleY = 1.0 / currentHeight * targetHeight;
            double scale = Math.min(scaleX, scaleY);
            int newWidth = (int)(currentWidth * scale);
            int newHeight = (int)(currentHeight * scale);
            Image newImage = sourceImage.getScaledInstance(newWidth, newHeight, highQuality ? 4 : 2);
            return RssHelper.waitFor(newImage);
        }
        return sourceImage;
    }

    public static Image waitFor(Image image) {
        try {
            MediaTracker tracker = new MediaTracker(DUMMY_COMP);
            tracker.addImage(image, 0);
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static String computeFileSizeString(long bytes) {
        if (bytes < 1024L) {
            return String.valueOf(DECIMAL_FORMAT.format(bytes)) + " B";
        }
        if (bytes < 0x100000L) {
            return String.valueOf(DECIMAL_FORMAT.format(bytes / 1024L)) + " KB";
        }
        return String.valueOf(FLOAT_FORMAT.format(bytes / 0x100000L)) + " MB";
    }

    public static String computeTimeString(long time) {
        if (time < 1000L) {
            return "0sec";
        }
        if (time < 60000L) {
            return String.valueOf(time / 1000L) + "sec";
        }
        long minutes = time / 60000L;
        long seconds = time / 1000L % 60L;
        return String.valueOf(minutes) + "min" + seconds + "sec";
    }

    public static JMenuItem createMenuItem(Action action, Icon icon) {
        JMenuItem item = new JMenuItem(action);
        if (icon != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JButton createButton(char mnemonic, Action action, Icon icon) {
        JButton button = new JButton(action);
        if (icon != null) {
            button.setIcon(icon);
        }
        button.setMnemonic(mnemonic);
        return button;
    }
}

