/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jperdian.rss2.RssParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RssParseHelper {
    private static final DateFormat DF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);

    public static URL parseURL(String sourceString) throws RssParseException {
        if (sourceString == null || sourceString.length() < 1) {
            return null;
        }
        try {
            return new URL(sourceString);
        }
        catch (MalformedURLException e) {
            throw new RssParseException("Illegal URL found: " + sourceString);
        }
    }

    private static String parseContent(Node node) {
        StringBuffer buffer = new StringBuffer();
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 3: 
            case 4: {
                String value = node.getNodeValue();
                if (value.length() <= 0) break;
                buffer.append(value);
                break;
            }
            case 1: {
                Element element = (Element)node;
                buffer.append("<").append(element.getNodeName());
                NamedNodeMap attributes = element.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    buffer.append(" ").append(attributes.item(i).getNodeName()).append("=\"");
                    buffer.append(attributes.item(i).getNodeValue()).append("\"");
                    ++i;
                }
                if (element.hasChildNodes()) {
                    buffer.append(">");
                    buffer.append(RssParseHelper.parseContentChildren(element));
                    buffer.append("</").append(element.getNodeName()).append(">");
                    break;
                }
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase("br") || nodeName.equalsIgnoreCase("hr") || nodeName.equalsIgnoreCase("input") || nodeName.equalsIgnoreCase("meta") || nodeName.equalsIgnoreCase("frame")) {
                    buffer.append(">");
                    break;
                }
                buffer.append("></").append(element.getNodeName()).append(">");
            }
        }
        return buffer.toString();
    }

    public static String parseContentChildren(Node node) {
        StringBuffer result = new StringBuffer();
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                result.append(RssParseHelper.parseContent(children.item(i)));
                ++i;
            }
        }
        return result.toString().trim();
    }

    public static Date parseContentDate(Element node) throws RssParseException {
        String content = RssParseHelper.parseContentChildren(node);
        if (content.length() < 1) {
            return null;
        }
        try {
            return DF.parse(content);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int parseContentInt(Element node) throws RssParseException {
        return RssParseHelper.parseContentInt(node, 0);
    }

    public static int parseContentInt(Element node, int defaultValue) throws RssParseException {
        String content = RssParseHelper.parseContentChildren(node);
        if (content.length() < 1) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException e) {
            throw new RssParseException("Illegal integer value found: " + content);
        }
    }

    public static URL parseContentURL(Element node) throws RssParseException {
        String content = RssParseHelper.parseContentChildren(node);
        return RssParseHelper.parseURL(content);
    }
}

