/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jperdian.rss2.RssException;
import org.jperdian.rss2.RssParseException;
import org.jperdian.rss2.RssParseHelper;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssCloud;
import org.jperdian.rss2.dom.RssEnclosure;
import org.jperdian.rss2.dom.RssGuid;
import org.jperdian.rss2.dom.RssImage;
import org.jperdian.rss2.dom.RssItem;
import org.jperdian.rss2.dom.RssTextInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RssParser {
    private DocumentBuilder myDocumentBuilder = null;

    public RssParser() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.setDocumentBuilder(builder);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot create DocumentBuilder", e);
        }
    }

    public RssChannel parse(URL sourceURL, RssChannel targetChannel) throws RssException {
        try {
            BufferedInputStream inStream = new BufferedInputStream(sourceURL.openStream());
            Document document = this.getDocumentBuilder().parse(inStream);
            ((InputStream)inStream).close();
            return this.parse(document, targetChannel);
        }
        catch (SAXException e) {
            throw new RssParseException("Illegal XML format \n[" + e.getMessage() + "]", e);
        }
        catch (IOException e) {
            throw new RssException("Cannot connect to source URL: " + sourceURL, e);
        }
    }

    public RssChannel parse(Document xmlDocument, RssChannel targetChannel) throws RssParseException {
        RssChannel resultChannel = null;
        Element rootElement = xmlDocument.getDocumentElement();
        NodeList rootSubNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < rootSubNodes.getLength()) {
            Node subNode = rootSubNodes.item(i);
            String subNodeName = subNode.getNodeName();
            if (subNode.getNodeType() == 1 && subNodeName.equalsIgnoreCase("channel")) {
                resultChannel = this.parseChannel((Element)rootSubNodes.item(i), targetChannel);
            } else if (subNodeName.equalsIgnoreCase("item")) {
                RssItem item = this.parseItem((Element)subNode);
                item.setSource(resultChannel);
                resultChannel.addItem(item);
            }
            ++i;
        }
        if (resultChannel != null) {
            return resultChannel;
        }
        throw new RssParseException("No channel element found in message");
    }

    protected RssChannel parseChannel(Element channelElement, RssChannel channel) throws RssParseException {
        List itemList = channel.getItemList();
        if (itemList != null && itemList.size() > 0) {
            itemList.clear();
        }
        NodeList subNodes = channelElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            if (subNodes.item(i).getNodeType() == 1) {
                Element subElement = (Element)subNodes.item(i);
                String elemName = subElement.getNodeName();
                if (elemName.equalsIgnoreCase("title")) {
                    channel.setTitle(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("link")) {
                    channel.setLink(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("description")) {
                    channel.setDescription(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("copyright")) {
                    channel.setCopyright(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("managingEditor")) {
                    channel.setManagingEditor(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("webMaster")) {
                    channel.setWebmaster(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("pubDate")) {
                    channel.setPubDate(RssParseHelper.parseContentDate(subElement));
                } else if (elemName.equalsIgnoreCase("lastBuildDate")) {
                    channel.setLastBuildDate(RssParseHelper.parseContentDate(subElement));
                } else if (elemName.equalsIgnoreCase("category")) {
                    channel.addCategory(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("generator")) {
                    channel.setGenerator(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("docs")) {
                    channel.setDocs(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("cloud")) {
                    channel.setCloud(this.parseCloud(subElement));
                } else if (elemName.equalsIgnoreCase("ttl")) {
                    channel.setTtl(RssParseHelper.parseContentInt(subElement));
                } else if (elemName.equalsIgnoreCase("image")) {
                    channel.setImage(this.parseImage(subElement));
                } else if (elemName.equalsIgnoreCase("rating")) {
                    channel.setRating(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("textInput")) {
                    channel.setTextInput(this.parseTextInput(subElement));
                } else if (elemName.equalsIgnoreCase("skipHours")) {
                    channel.addSkipHour(RssParseHelper.parseContentInt(subElement));
                } else if (elemName.equalsIgnoreCase("skipDays")) {
                    channel.addSkipDay(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("item")) {
                    RssItem item = this.parseItem(subElement);
                    item.setSource(channel);
                    channel.addItem(item);
                }
            }
            ++i;
        }
        return channel;
    }

    protected RssCloud parseCloud(Element cloudElement) throws RssParseException {
        RssCloud cloud = new RssCloud();
        cloud.setDomain(cloudElement.getAttribute("domain"));
        try {
            cloud.setPort(Integer.parseInt(cloudElement.getAttribute("port")));
        }
        catch (NumberFormatException e) {
            throw new RssParseException("Illegal port entered for cloud: " + cloudElement.getAttribute("port"));
        }
        cloud.setPath(cloudElement.getAttribute("path"));
        cloud.setRegisterProcedure(cloudElement.getAttribute("registerProcedure"));
        return cloud;
    }

    protected RssTextInput parseTextInput(Element textInputElement) throws RssParseException {
        RssTextInput textInput = new RssTextInput();
        NodeList subNodes = textInputElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            if (subNodes.item(i).getNodeType() == 1) {
                Element subElement = (Element)subNodes.item(i);
                String elemName = subElement.getNodeName();
                if (elemName.equalsIgnoreCase("title")) {
                    textInput.setTitle(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("description")) {
                    textInput.setDescription(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("name")) {
                    textInput.setName(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("link")) {
                    textInput.setLink(RssParseHelper.parseContentURL(subElement));
                }
            }
            ++i;
        }
        return textInput;
    }

    protected RssImage parseImage(Element textInputElement) throws RssParseException {
        RssImage image = new RssImage();
        NodeList subNodes = textInputElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            if (subNodes.item(i).getNodeType() == 1) {
                Element subElement = (Element)subNodes.item(i);
                String elemName = subElement.getNodeName();
                if (elemName.equalsIgnoreCase("title")) {
                    image.setTitle(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("url")) {
                    image.setURL(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("title")) {
                    image.setTitle(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("link")) {
                    image.setLink(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("description")) {
                    image.setDescription(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("width")) {
                    image.setWidth(RssParseHelper.parseContentInt(subElement, 88));
                } else if (elemName.equalsIgnoreCase("height")) {
                    image.setHeight(RssParseHelper.parseContentInt(subElement, 31));
                }
            }
            ++i;
        }
        return image;
    }

    protected RssItem parseItem(Element itemElement) throws RssParseException {
        RssItem item = new RssItem();
        NodeList subNodes = itemElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            if (subNodes.item(i).getNodeType() == 1) {
                Element subElement = (Element)subNodes.item(i);
                String elemName = subElement.getNodeName();
                if (elemName.equalsIgnoreCase("title")) {
                    item.setTitle(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("link")) {
                    item.setLink(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("description")) {
                    item.setDescription(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("author")) {
                    item.setAuthor(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("category")) {
                    item.addCategory(RssParseHelper.parseContentChildren(subElement));
                } else if (elemName.equalsIgnoreCase("comments")) {
                    item.setComments(RssParseHelper.parseContentURL(subElement));
                } else if (elemName.equalsIgnoreCase("enclosure")) {
                    item.setEnclosure(this.parseEnclosure(subElement));
                } else if (elemName.equalsIgnoreCase("guid")) {
                    item.setGuid(this.parseGuid(subElement));
                } else if (elemName.equalsIgnoreCase("pubDate")) {
                    item.setPubDate(RssParseHelper.parseContentDate(subElement));
                }
            }
            ++i;
        }
        return item;
    }

    protected RssEnclosure parseEnclosure(Element enclosureElement) throws RssParseException {
        RssEnclosure enclosure = new RssEnclosure();
        enclosure.setURL(RssParseHelper.parseURL(enclosureElement.getAttribute("url")));
        try {
            enclosure.setLength(Long.parseLong(enclosureElement.getAttribute("length")));
        }
        catch (NumberFormatException e) {
            throw new RssParseException("Illegal length entered for enclosure: " + enclosureElement.getAttribute("length"));
        }
        enclosure.setType(enclosureElement.getAttribute("type"));
        return enclosure;
    }

    protected RssGuid parseGuid(Element guidElement) throws RssParseException {
        RssGuid guid = new RssGuid();
        String permaLink = guidElement.getAttribute("isPermaLink");
        if (permaLink != null) {
            guid.setIsPermaLink(permaLink.equalsIgnoreCase("true"));
        }
        guid.setGuid(RssParseHelper.parseContentChildren(guidElement));
        return guid;
    }

    protected void setDocumentBuilder(DocumentBuilder builder) {
        this.myDocumentBuilder = builder;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return this.myDocumentBuilder;
    }
}

