/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jperdian.rss2.RssClient;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.util.CutCopyPastePopup;

public class RssChannelGetter
extends JFrame {
    private static RssChannelGetter ME = null;
    private JTextField myKeywordEditor = new JTextField();
    private JTextField myURLEditor = new JTextField();
    private JButton myOkButton = null;
    private JButton myCancelButton = null;

    public static void main(String[] args) {
        RssChannelGetter.requestChannel("x;xd;x");
    }

    public static void requestChannel(String keywords) {
        RssChannelGetter getter;
        RssChannelGetter rssChannelGetter = getter = RssChannelGetter.getInstance();
        synchronized (rssChannelGetter) {
            getter.getKeywordEditor().setText(keywords);
            getter.setVisible(true);
            getter.toFront();
            getter.requestFocus();
            getter.getURLEditor().selectAll();
            getter.getURLEditor().requestFocus();
        }
    }

    public RssChannelGetter() {
        super("Enter data for new channel");
        this.setDefaultCloseOperation(1);
        CutCopyPastePopup.attachTo(this.getKeywordEditor(), false);
        CutCopyPastePopup.attachTo(this.getURLEditor(), false);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Channel URL"), "North");
        topPanel.add((Component)this.getURLEditor(), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JLabel("Channel Keywords"), "North");
        bottomPanel.add((Component)this.getKeywordEditor(), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton(new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                RssChannelGetter getter = RssChannelGetter.getInstance();
                String url = RssChannelGetter.this.getURLEditor().getText();
                RssChannelGetter rssChannelGetter = getter;
                synchronized (rssChannelGetter) {
                    getter.getURLEditor().setEditable(false);
                    getter.getKeywordEditor().setEditable(false);
                    getter.getOkButton().setEnabled(false);
                    getter.getCancelButton().setEnabled(false);
                    if (url == null || url.trim().length() < 1) {
                        JOptionPane.showMessageDialog(RssChannelGetter.this, "No channel URL entered", "Warning", 2);
                        getter.getURLEditor().setEditable(true);
                        getter.getKeywordEditor().setEditable(true);
                        getter.getOkButton().setEnabled(true);
                        getter.getCancelButton().setEnabled(true);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(this, url, getter){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ String val$url;
                            private final /* synthetic */ RssChannelGetter val$getter;
                            {
                                this.this$1 = var1_1;
                                this.val$url = string;
                                this.val$getter = rssChannelGetter;
                            }

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run() {
                                block8: {
                                    RssChannel channel;
                                    block9: {
                                        channel = null;
                                        RssClient client = null;
                                        try {
                                            try {
                                                URL channelURL = new URL(this.val$url.trim());
                                                client = new RssClient(channelURL);
                                                channel = client.getData();
                                            }
                                            catch (MalformedURLException ex) {
                                                JOptionPane.showMessageDialog(1.access$0(this.this$1), "Illegal channel URL specified\n" + ex.getMessage(), "Error occured", 0);
                                            }
                                            catch (Exception ex) {
                                                JOptionPane.showMessageDialog(1.access$0(this.this$1), "Cannot open specified channel\n" + ex.getMessage(), "Error occured", 0);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var4_7 = null;
                                            if (channel != null) {
                                                if (channel.getTitle() == null || channel.getTitle().length() < 1) {
                                                    channel.setTitle(this.val$url.trim());
                                                }
                                                String keywords = 1.access$0(this.this$1).getKeywordEditor().getText();
                                                RssViewerFrame.getInstance().getChannelTree().addChannel(keywords, channel);
                                                1.access$0(this.this$1).hide();
                                            }
                                            this.val$getter.getURLEditor().setEditable(true);
                                            this.val$getter.getKeywordEditor().setEditable(true);
                                            this.val$getter.getOkButton().setEnabled(true);
                                            this.val$getter.getCancelButton().setEnabled(true);
                                            throw throwable;
                                        }
                                        {
                                            Object var4_8 = null;
                                            if (channel == null) break block8;
                                            if (channel.getTitle() != null && channel.getTitle().length() >= 1) break block9;
                                            channel.setTitle(this.val$url.trim());
                                        }
                                    }
                                    String keywords = 1.access$0(this.this$1).getKeywordEditor().getText();
                                    RssViewerFrame.getInstance().getChannelTree().addChannel(keywords, channel);
                                    1.access$0(this.this$1).hide();
                                }
                                this.val$getter.getURLEditor().setEditable(true);
                                this.val$getter.getKeywordEditor().setEditable(true);
                                this.val$getter.getOkButton().setEnabled(true);
                                this.val$getter.getCancelButton().setEnabled(true);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ RssChannelGetter access$0(1 var0) {
                return var0.RssChannelGetter.this;
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                RssChannelGetter.this.hide();
            }
        });
        this.setOkButton(okButton);
        this.setCancelButton(cancelButton);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel mainPanel = new JPanel(new GridLayout(3, 1, 0, 10));
        mainPanel.add(topPanel);
        mainPanel.add(bottomPanel);
        mainPanel.add(buttonPanel);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPanel);
    }

    static RssChannelGetter getInstance() {
        if (ME == null) {
            Point windowPoint = new Point(30, 30);
            if (RssViewerFrame.getInstance() != null) {
                windowPoint.setLocation(RssViewerFrame.getInstance().getLocation());
            }
            ME = new RssChannelGetter();
            ME.setBounds(windowPoint.x + 30, windowPoint.y + 30, 450, 190);
        }
        return ME;
    }

    JTextField getKeywordEditor() {
        return this.myKeywordEditor;
    }

    JTextField getURLEditor() {
        return this.myURLEditor;
    }

    private void setOkButton(JButton button) {
        this.myOkButton = button;
    }

    JButton getOkButton() {
        return this.myOkButton;
    }

    private void setCancelButton(JButton button) {
        this.myCancelButton = button;
    }

    JButton getCancelButton() {
        return this.myCancelButton;
    }
}

