/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jperdian.rss2.RssClient;
import org.jperdian.rss2.RssHelper;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.util.CutCopyPastePopup;

public class RssChannelInfo
extends JFrame {
    private RssChannelInfo(RssChannel channel) {
        this.setIconImage(RssHelper.getResourceImage("diskmap.gif"));
        RssClient client = channel.getClient();
        JTextField urlField = new JTextField();
        urlField.setEditable(false);
        urlField.setText(client.getURL().toString());
        CutCopyPastePopup.attachTo(urlField, true);
        FormLayout layout = new FormLayout("fill:pref:grow", "p, p, 10dlu, p, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        builder.addSeparator("Name", cc.xy(1, 1));
        builder.addLabel(channel.getTitle(), cc.xy(1, 2));
        builder.addSeparator("URL", cc.xy(1, 4));
        builder.add((Component)urlField, cc.xy(1, 5));
        JButton closeButton = new JButton(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                RssChannelInfo.this.dispose();
            }
        });
        closeButton.setIcon(RssHelper.getResourceImageIcon("exitIcon.png"));
        closeButton.setMnemonic('C');
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JPanel contentPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        buttonPanel.add(closeButton);
        contentPanel.add((Component)builder.getPanel(), "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.setContentPane(contentPanel);
    }

    public static void showInfo(RssChannel channel) {
        RssViewerFrame frame = RssViewerFrame.getInstance();
        RssChannelInfo info = new RssChannelInfo(channel);
        info.setTitle("Information for channel: " + channel.getTitle());
        info.setDefaultCloseOperation(2);
        info.setBounds(frame.getX() + 20, frame.getY() + 20, 400, 200);
        info.setVisible(true);
    }
}

