/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jperdian.rss2.RssException;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssItem;
import org.jperdian.rss2.gui.RssContentPanel;
import org.jperdian.rss2.gui.RssItemListTable;
import org.jperdian.rss2.gui.util.RssIoHelper;
import org.jperdian.rss2.rendering.PrintRenderer;

public class RssChannelPanel
extends JPanel {
    private RssItemListTable myListTable = null;
    private RssContentPanel myContentPanel = null;
    private RssChannel myChannel = null;
    private JButton myShowChannelButton = null;
    private JButton myReloadChannelButton = null;
    private JButton mySaveChannelButton = null;
    private JButton myPrintChannelButton = null;

    public RssChannelPanel(RssChannel channel) {
        this.setChannel(channel);
        this.setLayout(new BorderLayout());
        this.initComponents();
    }

    protected void initComponents() {
        this.setListTable(new RssItemListTable());
        this.setContentPanel(new RssContentPanel());
        JScrollPane listScroller = new JScrollPane(this.getListTable());
        listScroller.setMinimumSize(new Dimension(0, 130));
        listScroller.setPreferredSize(new Dimension(0, 150));
        JSplitPane contentSplitter = new JSplitPane(0);
        contentSplitter.setTopComponent(listScroller);
        contentSplitter.setBottomComponent(this.getContentPanel());
        this.add((Component)contentSplitter, "Center");
        JPanel titlePanel = new JPanel(new FlowLayout(1));
        JButton showChannelButton = new JButton(new AbstractAction("Show complete channel"){

            public void actionPerformed(ActionEvent e) {
                RssChannelPanel.this.getContentPanel().showChannel(RssChannelPanel.this.getChannel());
            }
        });
        showChannelButton.setMnemonic('c');
        this.setShowChannelButton(showChannelButton);
        JButton reloadButton = new JButton(new AbstractAction("Reload"){

            public void actionPerformed(ActionEvent e) {
                RssChannelPanel.this.reload();
            }
        });
        reloadButton.setMnemonic('R');
        this.setReloadChannelButton(reloadButton);
        JButton saveButton = new JButton(new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                RssIoHelper.saveContent(RssChannelPanel.this.getChannel());
            }
        });
        saveButton.setMnemonic('S');
        this.setSaveChannelButton(saveButton);
        JButton printButton = new JButton(new AbstractAction("Print"){

            public void actionPerformed(ActionEvent e) {
                JEditorPane editor = RssChannelPanel.this.getContentPanel().getEditorPane();
                PrintRenderer renderer = new PrintRenderer();
                renderer.print(editor);
            }
        });
        printButton.setMnemonic('P');
        this.setPrintChannelButton(printButton);
        titlePanel.add(showChannelButton);
        titlePanel.add(reloadButton);
        titlePanel.add(saveButton);
        titlePanel.add(printButton);
        this.add((Component)titlePanel, "North");
        this.getListTable().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                List itemList;
                int selectedItem;
                if (e.getButton() == 1 && (selectedItem = RssChannelPanel.this.getListTable().getSelectedRow()) < (itemList = RssChannelPanel.this.getChannel().getItemList()).size()) {
                    RssChannelPanel.this.getContentPanel().showItem((RssItem)itemList.get(selectedItem));
                }
            }
        });
    }

    public void setButtonsEnabled(boolean state, boolean reloadState) {
        this.getSaveChannelButton().setEnabled(state);
        this.getPrintChannelButton().setEnabled(state);
        this.getShowChannelButton().setEnabled(state);
        this.getReloadChannelButton().setEnabled(reloadState);
        this.getListTable().setEnabled(state);
    }

    public void reload() {
        this.setButtonsEnabled(false, false);
        this.getListTable().clear();
        this.getContentPanel().showLoadingInfo();
        new Thread(){

            public void run() {
                try {
                    RssChannelPanel.this.getChannel().update();
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            6.access$0(this.this$1).getListTable().showChannel(6.access$0(this.this$1).getChannel());
                            6.access$0(this.this$1).getContentPanel().showChannel(6.access$0(this.this$1).getChannel());
                            6.access$0(this.this$1).setButtonsEnabled(true, true);
                        }
                    });
                }
                catch (RssException e) {
                    RssChannelPanel.this.getContentPanel().showLoadingFailure(e);
                    RssChannelPanel.this.setButtonsEnabled(false, true);
                }
            }

            static /* synthetic */ RssChannelPanel access$0(6 var0) {
                return var0.RssChannelPanel.this;
            }
        }.start();
    }

    private void setChannel(RssChannel channel) {
        this.myChannel = channel;
    }

    public RssChannel getChannel() {
        return this.myChannel;
    }

    protected void setListTable(RssItemListTable table) {
        this.myListTable = table;
    }

    public RssItemListTable getListTable() {
        return this.myListTable;
    }

    protected void setContentPanel(RssContentPanel panel) {
        this.myContentPanel = panel;
    }

    public RssContentPanel getContentPanel() {
        return this.myContentPanel;
    }

    protected void setShowChannelButton(JButton button) {
        this.myShowChannelButton = button;
    }

    protected JButton getShowChannelButton() {
        return this.myShowChannelButton;
    }

    protected void setSaveChannelButton(JButton button) {
        this.mySaveChannelButton = button;
    }

    protected JButton getSaveChannelButton() {
        return this.mySaveChannelButton;
    }

    protected void setReloadChannelButton(JButton button) {
        this.myReloadChannelButton = button;
    }

    protected JButton getReloadChannelButton() {
        return this.myReloadChannelButton;
    }

    protected void setPrintChannelButton(JButton button) {
        this.myPrintChannelButton = button;
    }

    protected JButton getPrintChannelButton() {
        return this.myPrintChannelButton;
    }
}

