/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jperdian.rss2.RssException;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssItem;
import org.jperdian.rss2.gui.util.BrowserLauncher;
import org.jperdian.rss2.gui.util.CutCopyPastePopup;
import org.jperdian.rss2.rendering.Html3Renderer;
import org.jperdian.rss2.rendering.HtmlHelper;
import org.jperdian.rss2.rendering.HtmlRenderer;

public class RssContentPanel
extends JPanel {
    private HtmlRenderer HR = new Html3Renderer();
    private JEditorPane myEditorPane = new JEditorPane();

    public RssContentPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getEditorPane()), "Center");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        editorKit.getStyleSheet().addRule(HtmlHelper.getDefaultStyles());
        this.getEditorPane().setEditable(false);
        this.getEditorPane().setEditorKit(editorKit);
        this.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        CutCopyPastePopup.attachTo(this.getEditorPane(), true);
    }

    public void showItem(RssItem item) {
        this.showText(this.HR.renderItem(item));
    }

    public void showChannel(RssChannel channel) {
        this.showText(this.HR.renderChannel(channel));
    }

    public void showLoadingInfo() {
        String loadingText = "<p><center><big>Loading content...</big></center></p>";
        this.showText(loadingText);
    }

    public void showLoadingFailure(RssException e) {
        StringBuffer errorText = new StringBuffer("<p><center><big>Loading failed:</big></center></p>");
        errorText.append("<p><code>").append(e.toString()).append("</code></p>");
        this.showText(errorText);
    }

    protected void showText(Object text) {
        this.getEditorPane().setText(String.valueOf(text));
        this.getEditorPane().setCaretPosition(0);
        this.getEditorPane().setSelectionStart(0);
    }

    public JEditorPane getEditorPane() {
        return this.myEditorPane;
    }
}

