/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssItem;
import org.jperdian.rss2.gui.RssItemTableModel;

public class RssItemListTable
extends JTable {
    private static final Color COLOR_NORMAL = new Color(255, 255, 255);
    private static final Color COLOR_SELECTED = new Color(223, 223, 223);

    public RssItemListTable() {
        super(new RssItemTableModel());
        int[][] widthDefs = RssItemTableModel.getWidthDefinitions();
        int i = 0;
        while (i < widthDefs.length) {
            if (widthDefs[i][0] > 0) {
                this.getColumnModel().getColumn(i).setPreferredWidth(widthDefs[i][0]);
            }
            if (widthDefs[i][1] > 0) {
                this.getColumnModel().getColumn(i).setMinWidth(widthDefs[i][1]);
            }
            if (widthDefs[i][2] > 0) {
                this.getColumnModel().getColumn(i).setMaxWidth(widthDefs[i][2]);
            }
            ++i;
        }
        this.setSelectionMode(0);
    }

    public void clear() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    public void showChannel(RssChannel channel) {
        List newItemList = channel.getItemList();
        int i = 0;
        while (i < newItemList.size()) {
            this.addItem((RssItem)newItemList.get(i));
            ++i;
        }
        this.validate();
    }

    public void addItem(RssItem item) {
        RssItemTableModel model = (RssItemTableModel)this.getModel();
        model.addRow(model.createRowData(item));
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (row % 2 == 0) {
            ((JComponent)((Object)renderer)).setBackground(COLOR_SELECTED);
        } else {
            ((JComponent)((Object)renderer)).setBackground(COLOR_NORMAL);
        }
        return renderer;
    }
}

