/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.jperdian.rss2.dom.RssItem;

class RssItemTableModel
extends DefaultTableModel {
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static int[][] getWidthDefinitions() {
        return new int[][]{{100, 100, 100}, new int[3]};
    }

    public RssItemTableModel() {
        super(new Object[]{"Date", "Title"}, 0);
    }

    public Vector createRowData(RssItem item) {
        Vector<String> result = new Vector<String>();
        result.add(item.getPubDate() == null ? "(No date)" : DF.format(item.getPubDate()));
        result.add(item.getTitle() == null ? "(No title)" : item.getTitle());
        return result;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

