/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.gui.RssChannelPanel;
import org.jperdian.rss2.gui.RssViewerMenuBar;
import org.jperdian.rss2.gui.tree.RssChannelTree;
import org.jperdian.rss2.gui.util.RssIoHelper;

public class RssViewerFrame
extends JFrame {
    private static RssViewerFrame myInstance = new RssViewerFrame();
    private int myMaxChannels = 20;
    private RssChannelTree myChannelTree = null;
    private JTabbedPane myMainTabber = null;

    public RssViewerFrame() {
        super("RSS Viewer Version 2.1 (c) 2003-2004 by Christian Robert");
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RssViewerFrame.getInstance().requestExit();
            }
        });
    }

    public void initComponents() {
        this.getContentPane().removeAll();
        this.setJMenuBar(new RssViewerMenuBar());
        JTabbedPane mainTabber = new JTabbedPane();
        RssChannelTree channelTree = new RssChannelTree();
        this.setMainTabber(mainTabber);
        this.setChannelTree(channelTree);
        Container contentPane = this.getContentPane();
        JSplitPane mainSplitter = new JSplitPane(1);
        JScrollPane channelTreeScroller = new JScrollPane(channelTree);
        channelTreeScroller.setAutoscrolls(true);
        channelTreeScroller.setMinimumSize(new Dimension(150, 0));
        channelTreeScroller.setPreferredSize(new Dimension(200, 0));
        mainSplitter.setLeftComponent(channelTreeScroller);
        mainSplitter.setRightComponent(mainTabber);
        contentPane.add((Component)mainSplitter, "Center");
    }

    public void initSavedData() throws Exception {
        File prefsFile = new File("./init/default.xml");
        if (prefsFile.exists()) {
            RssIoHelper.loadFile(prefsFile, false);
        }
    }

    public void requestExit() {
        this.dispose();
    }

    public void requestDisplay(RssChannel channel) {
        RssChannelPanel mainPanel = null;
        Component[] components = this.getMainTabber().getComponents();
        int i = 0;
        while (i < components.length) {
            RssChannelPanel panel;
            if (components[i] instanceof RssChannelPanel && (panel = (RssChannelPanel)components[i]).getChannel().equals(channel)) {
                this.getMainTabber().setSelectedComponent(panel);
                mainPanel = panel;
            }
            ++i;
        }
        if (mainPanel == null) {
            mainPanel = new RssChannelPanel(channel);
            String newTitle = channel.getTitle();
            if (this.getMainTabber().getComponentCount() >= this.getMaxChannels()) {
                this.getMainTabber().remove(0);
            }
            this.getMainTabber().add(newTitle, mainPanel);
            this.getMainTabber().setSelectedComponent(mainPanel);
        }
        mainPanel.reload();
    }

    static void setInstance(RssViewerFrame instance) {
        myInstance = instance;
    }

    public static RssViewerFrame getInstance() {
        return myInstance;
    }

    protected void setMainTabber(JTabbedPane tabber) {
        this.myMainTabber = tabber;
    }

    public JTabbedPane getMainTabber() {
        return this.myMainTabber;
    }

    protected void setChannelTree(RssChannelTree tree) {
        this.myChannelTree = tree;
    }

    public RssChannelTree getChannelTree() {
        return this.myChannelTree;
    }

    public void setMaxChannels(int numberOfChannels) {
        this.myMaxChannels = numberOfChannels;
    }

    public int getMaxChannels() {
        return this.myMaxChannels;
    }
}

