/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jperdian.rss2.RssHelper;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.util.RssIoHelper;

public class RssViewerMenuBar
extends JMenuBar {
    public RssViewerMenuBar() {
        this.initItems();
    }

    protected void initItems() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.add(fileMenu);
        JMenuItem loadItem = new JMenuItem(new AbstractAction("Load channels"){

            public void actionPerformed(ActionEvent e) {
                try {
                    RssIoHelper.loadFile();
                }
                catch (Exception ex) {
                    String message = "Cannot load file: " + ex.getMessage();
                    JOptionPane.showMessageDialog(RssViewerFrame.getInstance(), message, "Error occured", 0);
                }
            }
        });
        loadItem.setIcon(RssHelper.getResourceImageIcon("loadIcon.png"));
        loadItem.setMnemonic('L');
        fileMenu.add(loadItem);
        JMenuItem saveItem = new JMenuItem(new AbstractAction("Save channels"){

            public void actionPerformed(ActionEvent e) {
                try {
                    RssIoHelper.saveFile();
                }
                catch (IOException ex) {
                    String message = "Cannot save file: " + ex.getMessage();
                    JOptionPane.showMessageDialog(RssViewerFrame.getInstance(), message, "Error occured", 0);
                }
            }
        });
        saveItem.setIcon(RssHelper.getResourceImageIcon("saveIcon.png"));
        saveItem.setMnemonic('S');
        fileMenu.add(saveItem);
        JMenuItem exitItem = new JMenuItem(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                RssViewerFrame.getInstance().requestExit();
            }
        });
        exitItem.setIcon(RssHelper.getResourceImageIcon("exitIcon.png"));
        exitItem.setMnemonic('x');
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        this.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(new AbstractAction("About"){

            public void actionPerformed(ActionEvent e) {
            }
        });
        aboutItem.setIcon(RssHelper.getResourceImageIcon("aboutIcon.png"));
        aboutItem.setMnemonic('A');
        helpMenu.add(aboutItem);
    }
}

