/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jperdian.rss2.RssClient;
import org.jperdian.rss2.RssException;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.tree.RssChannelNode;
import org.jperdian.rss2.gui.tree.RssChannelTreeModel;
import org.jperdian.rss2.gui.tree.RssChannelTreePopupMenu;
import org.jperdian.rss2.gui.tree.RssKeywordNode;

public class RssChannelTree
extends JTree {
    private RssChannelTreePopupMenu myPopupMenu = null;

    public RssChannelTree() {
        super(new RssChannelTreeModel());
        this.setPopupMenu(new RssChannelTreePopupMenu());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() >= 2) {
                    Object lastComponent;
                    TreePath selectedPath = RssChannelTree.this.getSelectionPath();
                    if (selectedPath != null && (lastComponent = selectedPath.getLastPathComponent()) instanceof RssChannelNode) {
                        RssChannelNode node = (RssChannelNode)lastComponent;
                        RssChannel channel = node.getChannel();
                        RssViewerFrame.getInstance().requestDisplay(channel);
                    }
                } else if (e.getClickCount() == 1 && e.getButton() == 3 && RssChannelTree.this.getSelectionCount() > 0) {
                    RssChannelTreePopupMenu treePopup = RssChannelTree.this.getPopupMenu();
                    treePopup.show(RssChannelTree.this, e.getX(), e.getY());
                }
            }
        });
    }

    public void addClient(RssClient client) {
        this.addClient(client, true);
    }

    public void addClient(RssClient client, boolean loadData) {
        String title = client.getTitle();
        String keywords = client.getKeywords();
        RssChannel channel = new RssChannel(client);
        if (loadData) {
            try {
                channel.update();
            }
            catch (RssException e) {
                channel.setDataLoadFailed(true);
                channel.setTitle(title);
            }
        } else {
            channel.setTitle(title);
        }
        this.addChannel(keywords, channel);
    }

    public void addChannel(String keywords, RssChannel channel) {
        RssChannelTreeModel model = (RssChannelTreeModel)this.getModel();
        RssChannelNode node = new RssChannelNode(channel);
        MutableTreeNode rootNode = (MutableTreeNode)this.getModel().getRoot();
        MutableTreeNode parentNode = this.getKeywordNode(keywords, rootNode, model);
        int index = parentNode.getChildCount();
        int i = 0;
        while (i < parentNode.getChildCount()) {
            int compareResult = node.compareTo(parentNode.getChildAt(i));
            if (compareResult < 0) {
                index = i;
                break;
            }
            ++i;
        }
        model.insertNodeInto(node, parentNode, index);
        TreePath nodePath = this.getPathForRow(0);
        if (!this.isExpanded(nodePath)) {
            this.setExpandedState(nodePath, true);
        }
    }

    protected MutableTreeNode getKeywordNode(String keywords, MutableTreeNode parentNode, RssChannelTreeModel model) {
        if (keywords == null || keywords.length() < 1) {
            return parentNode;
        }
        int keywordEndMarker = keywords.indexOf(";");
        RssKeywordNode childNode = null;
        String currentKeywordName = keywordEndMarker < 0 ? keywords : keywords.substring(0, keywordEndMarker);
        int i = 0;
        while (i < parentNode.getChildCount()) {
            RssKeywordNode groupNode;
            if (parentNode.getChildAt(i) instanceof RssKeywordNode && (groupNode = (RssKeywordNode)parentNode.getChildAt(i)).getUserObject().toString().equalsIgnoreCase(currentKeywordName)) {
                childNode = groupNode;
                break;
            }
            ++i;
        }
        if (childNode == null) {
            childNode = new RssKeywordNode(currentKeywordName);
            int index = parentNode.getChildCount();
            int i2 = 0;
            while (i2 < parentNode.getChildCount()) {
                Comparable item = (Comparable)((Object)parentNode.getChildAt(i2));
                int compareResult = ((Comparable)childNode).compareTo(item);
                if (compareResult < 0) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            model.insertNodeInto(childNode, parentNode, index);
        }
        if (keywordEndMarker < 0) {
            return childNode;
        }
        String newKeywords = keywords.substring(keywordEndMarker + 1);
        return this.getKeywordNode(newKeywords, childNode, model);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    private void setPopupMenu(RssChannelTreePopupMenu menu) {
        this.myPopupMenu = menu;
    }

    RssChannelTreePopupMenu getPopupMenu() {
        return this.myPopupMenu;
    }
}

