/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui.tree;

import java.awt.event.ActionEvent;
import java.util.Timer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jperdian.rss2.RssHelper;
import org.jperdian.rss2.gui.RssChannelGetter;
import org.jperdian.rss2.gui.RssChannelInfo;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.tree.RssChannelNode;
import org.jperdian.rss2.gui.tree.RssChannelTree;
import org.jperdian.rss2.gui.tree.RssChannelTreeModel;
import org.jperdian.rss2.gui.tree.RssKeywordNode;

public class RssChannelTreePopupMenu
extends JPopupMenu {
    public RssChannelTreePopupMenu() {
        super("Options");
        this.initItem('A', new AbstractAction("Add new Channel"){

            public void actionPerformed(ActionEvent e) {
                RssChannelTree tree = RssViewerFrame.getInstance().getChannelTree();
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    RssChannelTreeModel model = (RssChannelTreeModel)tree.getModel();
                    MutableTreeNode lastNode = (MutableTreeNode)path.getLastPathComponent();
                    RssKeywordNode keywordNode = null;
                    DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
                    StringBuffer keywords = new StringBuffer();
                    keywordNode = lastNode instanceof RssChannelNode ? (RssKeywordNode)lastNode.getParent() : (RssKeywordNode)lastNode;
                    while (keywordNode != null && keywordNode != rootNode) {
                        keywords.insert(0, keywordNode.toString());
                        if (keywordNode.getParent() != null && keywordNode.getParent() != rootNode) {
                            keywords.insert(0, ';');
                        }
                        keywordNode = (RssKeywordNode)keywordNode.getParent();
                    }
                    RssChannelGetter.requestChannel(keywords.toString());
                }
            }
        }, "addIcon.png");
        this.initItem('R', new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                RssChannelTree tree = RssViewerFrame.getInstance().getChannelTree();
                DefaultMutableTreeNode rootNode = tree.getRootNode();
                TreePath[] pathArray = tree.getSelectionPaths();
                if (pathArray != null && pathArray.length > 0) {
                    int i = 0;
                    while (i < pathArray.length) {
                        MutableTreeNode endNode = (MutableTreeNode)pathArray[i].getLastPathComponent();
                        if (endNode == rootNode) {
                            JOptionPane.showMessageDialog(RssViewerFrame.getInstance(), "Cannot remove root entry", "Error", 0);
                        } else {
                            MutableTreeNode parentNode = (MutableTreeNode)endNode.getParent();
                            endNode.removeFromParent();
                            if (parentNode.getChildCount() == 0) {
                                while (parentNode.getChildCount() == 0 && parentNode != rootNode) {
                                    MutableTreeNode oldParent = parentNode;
                                    parentNode = (MutableTreeNode)parentNode.getParent();
                                    oldParent.removeFromParent();
                                }
                            }
                            ((RssChannelTreeModel)tree.getModel()).reload(parentNode);
                        }
                        ++i;
                    }
                }
            }
        }, "xIcon.png");
        this.initItem('I', new AbstractAction("Channel Info"){

            public void actionPerformed(ActionEvent e) {
                RssChannelTree tree = RssViewerFrame.getInstance().getChannelTree();
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    RssChannelTreeModel model = (RssChannelTreeModel)tree.getModel();
                    MutableTreeNode lastNode = (MutableTreeNode)path.getLastPathComponent();
                    if (lastNode instanceof RssChannelNode) {
                        RssChannelInfo.showInfo(((RssChannelNode)lastNode).getChannel());
                    }
                }
            }
        }, "infoIcon.png");
    }

    private JMenuItem initItem(char mnemonic, Action action, String iconName) {
        JMenuItem item = new JMenuItem(action);
        item.setMnemonic(mnemonic);
        Timer t = new Timer();
        if (iconName != null) {
            item.setIcon(RssHelper.getResourceImageIcon(iconName));
        }
        this.add(item);
        return item;
    }
}

