/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.jperdian.rss2.RssHelper;

public class CutCopyPastePopup
extends JPopupMenu
implements ClipboardOwner {
    private JMenuItem mySelectAllItem = null;
    private JMenuItem myCopyItem = null;
    private JMenuItem myCopyAllItem = null;
    private JMenuItem myPasteItem = null;
    private JMenuItem myCutItem = null;
    private JTextComponent myTextComponent = null;

    private CutCopyPastePopup(JTextComponent component, boolean readOnly) {
        this.setTextComponent(component);
        this.setCopyItem(RssHelper.createMenuItem(new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent e) {
                CutCopyPastePopup.this.handleCopy();
            }
        }, RssHelper.getResourceImageIcon("copyIcon.png")));
        this.setCopyAllItem(RssHelper.createMenuItem(new AbstractAction("Copy All"){

            public void actionPerformed(ActionEvent e) {
                CutCopyPastePopup.this.handleSelectAll();
                CutCopyPastePopup.this.handleCopy();
            }
        }, RssHelper.getResourceImageIcon("copyIcon.png")));
        this.setCutItem(RssHelper.createMenuItem(new AbstractAction("Cut"){

            public void actionPerformed(ActionEvent e) {
                CutCopyPastePopup.this.handleCut();
            }
        }, RssHelper.getResourceImageIcon("cutIcon.png")));
        this.setPasteItem(RssHelper.createMenuItem(new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent e) {
                CutCopyPastePopup.this.handlePaste();
            }
        }, RssHelper.getResourceImageIcon("pasteIcon.png")));
        this.setSelectAllItem(RssHelper.createMenuItem(new AbstractAction("Select all"){

            public void actionPerformed(ActionEvent e) {
                CutCopyPastePopup.this.handleSelectAll();
            }
        }, RssHelper.getResourceImageIcon("selectAllIcon.png")));
        this.add(this.getCopyItem());
        this.add(this.getCopyAllItem());
        if (!readOnly) {
            this.add(this.getPasteItem());
            this.add(this.getCutItem());
        }
        this.add(this.getSelectAllItem());
    }

    public static void attachTo(JTextComponent component, boolean readOnly) {
        CutCopyPastePopup popup = new CutCopyPastePopup(component, readOnly);
        component.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CutCopyPastePopup.this.handleClick(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CutCopyPastePopup.this.handleClick(e);
                }
            }
        });
    }

    protected void handleClick(MouseEvent e) {
        String clipValue = this.clipboardGet();
        String myValue = this.getTextComponent().getSelectedText();
        String totalValue = this.getTextComponent().getText();
        this.getCopyItem().setEnabled(myValue != null && myValue.length() > 0);
        this.getCopyAllItem().setEnabled(totalValue != null && totalValue.length() > 0);
        this.getPasteItem().setEnabled(clipValue != null && clipValue.length() > 0);
        this.getCutItem().setEnabled(myValue != null && myValue.length() > 0);
        this.getSelectAllItem().setEnabled(totalValue != null && totalValue.length() > 0);
        this.show(e.getComponent(), e.getX(), e.getY());
    }

    public void handleCopy() {
        String currentText = this.getTextComponent().getSelectedText();
        this.clipboardSet(currentText);
    }

    public void handleCut() {
        this.handleCopy();
        this.getTextComponent().setText("");
    }

    public void handlePaste() {
        this.getTextComponent().setText(this.clipboardGet());
    }

    public void handleSelectAll() {
        this.getTextComponent().selectAll();
    }

    public String clipboardGet() {
        Clipboard board = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = board.getContents(null);
        if (transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)transfer.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public void clipboardSet(String value) {
        Clipboard board = Toolkit.getDefaultToolkit().getSystemClipboard();
        board.setContents(new StringSelection(value), this);
    }

    public void setTextComponent(JTextComponent component) {
        this.myTextComponent = component;
    }

    public JTextComponent getTextComponent() {
        return this.myTextComponent;
    }

    private void setCopyItem(JMenuItem item) {
        this.myCopyItem = item;
    }

    private JMenuItem getCopyItem() {
        return this.myCopyItem;
    }

    private void setCopyAllItem(JMenuItem item) {
        this.myCopyAllItem = item;
    }

    private JMenuItem getCopyAllItem() {
        return this.myCopyAllItem;
    }

    private void setCutItem(JMenuItem item) {
        this.myCutItem = item;
    }

    private JMenuItem getCutItem() {
        return this.myCutItem;
    }

    private void setPasteItem(JMenuItem item) {
        this.myPasteItem = item;
    }

    private JMenuItem getPasteItem() {
        return this.myPasteItem;
    }

    private void setSelectAllItem(JMenuItem item) {
        this.mySelectAllItem = item;
    }

    private JMenuItem getSelectAllItem() {
        return this.mySelectAllItem;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

