/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.gui.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jperdian.rss2.RssClient;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.gui.RssViewerFrame;
import org.jperdian.rss2.gui.tree.RssChannelNode;
import org.jperdian.rss2.gui.tree.RssChannelTree;
import org.jperdian.rss2.gui.tree.RssChannelTreeModel;
import org.jperdian.rss2.gui.tree.RssKeywordNode;
import org.jperdian.rss2.rendering.Html4Renderer;
import org.jperdian.rss2.rendering.HtmlRenderer;
import org.jperdian.swing.tools.ExtensionFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RssIoHelper {
    private static JFileChooser fileChooser = new JFileChooser(new File("."));
    private static final FileFilter FILTER_XML = new ExtensionFileFilter("xml", "XML Files");
    private static final FileFilter FILTER_HTML = new ExtensionFileFilter(new String[]{"html", "htm"}, "HTML Files");
    private static final HtmlRenderer HR = new Html4Renderer();

    public static synchronized void loadFile() throws Exception {
        fileChooser.setFileFilter(FILTER_XML);
        int result = fileChooser.showOpenDialog(RssViewerFrame.getInstance());
        if (result == 0) {
            RssIoHelper.loadFile(fileChooser.getSelectedFile(), true);
        }
    }

    public static void loadFile(File file, boolean removeOldNodes) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(file);
        NodeList childNodes = doc.getDocumentElement().getChildNodes();
        ArrayList<RssClient> clientList = new ArrayList<RssClient>(childNodes.getLength());
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1 && childNodes.item(i).getNodeName().equalsIgnoreCase("channel")) {
                Element elem = (Element)childNodes.item(i);
                String title = elem.getAttribute("title");
                String keywords = elem.getAttribute("keywords");
                URL url = new URL(URLDecoder.decode(elem.getAttribute("url"), "ISO-8859-1"));
                RssClient client = new RssClient(url, keywords, title);
                clientList.add(client);
            }
            ++i;
        }
        RssChannelTree tree = RssViewerFrame.getInstance().getChannelTree();
        RssChannelTreeModel model = (RssChannelTreeModel)tree.getModel();
        DefaultMutableTreeNode rootNode = tree.getRootNode();
        if (removeOldNodes) {
            rootNode.removeAllChildren();
            model.reload(rootNode);
        }
        int i2 = 0;
        while (i2 < clientList.size()) {
            tree.addClient((RssClient)clientList.get(i2), false);
            ++i2;
        }
    }

    public static synchronized void saveFile() throws IOException {
        fileChooser.setFileFilter(FILTER_XML);
        int result = fileChooser.showSaveDialog(RssViewerFrame.getInstance());
        if (result == 0) {
            File theFile = fileChooser.getSelectedFile();
            if (theFile.getName().indexOf(".") < 0) {
                theFile = new File(String.valueOf(theFile.getAbsolutePath()) + ".xml");
            }
            boolean goSave = true;
            if (theFile.exists()) {
                result = JOptionPane.showConfirmDialog(RssViewerFrame.getInstance(), String.valueOf(theFile.getName()) + "\nFile already existing. Overwrite?", "Overwrite existing file?", 0);
                boolean bl = goSave = result == 0;
            }
            if (goSave) {
                RssIoHelper.saveFile(theFile);
            }
        }
    }

    private static void saveFile(File file) throws IOException {
        StringBuffer document = RssIoHelper.createDocument();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(document.toString());
        writer.flush();
        writer.close();
    }

    public static synchronized void saveContent(RssChannel channel) {
        fileChooser.setFileFilter(FILTER_HTML);
        int result = fileChooser.showSaveDialog(RssViewerFrame.getInstance());
        if (result == 0) {
            File theFile = fileChooser.getSelectedFile();
            if (theFile.getName().indexOf(".") < 0) {
                theFile = new File(String.valueOf(theFile.getAbsolutePath()) + ".html");
            }
            boolean goSave = true;
            try {
                if (theFile.exists()) {
                    result = JOptionPane.showConfirmDialog(RssViewerFrame.getInstance(), String.valueOf(theFile.getName()) + "\nFile already existing. Overwrite?", "Overwrite existing file?", 0);
                    goSave = result == 0;
                } else {
                    theFile.createNewFile();
                }
                if (goSave) {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(theFile));
                    writer.write(HR.renderChannel(channel).toString());
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(RssViewerFrame.getInstance(), "Cannot save into file " + theFile.getName() + "\n" + e.getMessage(), "Error occured", 0);
            }
        }
    }

    private static StringBuffer createDocument() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        result.append("<rssChannelList>\n");
        DefaultMutableTreeNode rootNode = RssViewerFrame.getInstance().getChannelTree().getRootNode();
        RssIoHelper.addNodes(result, "", rootNode, 0);
        result.append("\n\n</rssChannelList>");
        return result;
    }

    private static void addNodes(StringBuffer result, String oldKeywords, DefaultMutableTreeNode node, int level) {
        int i = 0;
        while (i < node.getChildCount()) {
            TreeNode childNode = node.getChildAt(i);
            String newKeywords = String.valueOf(oldKeywords) + (level > 0 ? ";" : "") + childNode.toString();
            if (childNode instanceof RssKeywordNode) {
                RssIoHelper.addNodes(result, newKeywords, (RssKeywordNode)childNode, level + 1);
            } else if (childNode instanceof RssChannelNode) {
                try {
                    RssChannel channel = ((RssChannelNode)childNode).getChannel();
                    result.append("\n  <channel title=\"").append(channel.getTitle());
                    result.append("\" keywords=\"").append(oldKeywords).append("\" url=\"");
                    result.append(URLEncoder.encode(channel.getClient().getURL().toString(), "ISO-8859-1"));
                    result.append("\" />");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("ISO-8859-1 encoding not supported");
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        System.err.println(URLEncoder.encode("http://www.rtlshop.de/rtlshop/servlet/rtlshop/admin/orders/rss.xml?relayLogin=true&email=crobert@braintags.de&userpassword=gundula", "ISO-8859-1"));
    }
}

