/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.rendering;

import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssImage;
import org.jperdian.rss2.dom.RssItem;
import org.jperdian.rss2.rendering.HtmlRenderer;

public class Html3Renderer
extends HtmlRenderer {
    protected void renderChannelHead(RssChannel channel, StringBuffer buffer) {
        RssImage image = channel.getImage();
        buffer.append("<table bgcolor=\"#eeeeee\" width=\"100%\" border=\"1\" cellpadding=\"4\" cellspacing=\"0\"><td><table border=\"0\" width=\"100%\" cellpadding=\"4\">");
        buffer.append("<tr>");
        if (image != null && image.getURL() != null) {
            buffer.append("<td align=\"center\" width=\"").append(image.getWidth() + 15).append("\">");
            buffer.append("<img src=\"").append(image.getURL()).append("\">");
            buffer.append("</td>");
        }
        buffer.append("<td align=\"center\">");
        if (channel.getTitle() != null && channel.getTitle().length() > 0) {
            buffer.append("<font size=\"6\"><b>").append(channel.getTitle()).append("</b></font>");
        }
        if (channel.getDescription().length() > 0) {
            if (channel.getTitle() != null && channel.getTitle().length() > 0) {
                buffer.append("<br>");
            }
            buffer.append("<font size=\"4\">").append(channel.getDescription()).append("</font>");
        }
        StringBuffer subBuffer = new StringBuffer();
        if (channel.getWebmaster() != null && channel.getWebmaster().length() > 0) {
            subBuffer.append("<br><font size=\"4\"><a href=\"mailto:").append(channel.getWebmaster()).append("\">").append(channel.getWebmaster()).append("</a></font>");
        }
        if (channel.getLink() != null) {
            if (subBuffer.length() > 0) {
                subBuffer.append(" &nbsp;|&nbsp; ");
            } else {
                subBuffer.append("<br>");
            }
            subBuffer.append("<font size=\"4\"><a href=\"").append(channel.getLink()).append("\">").append(channel.getLink()).append("</a></font>");
        }
        if (channel.getPubDate() != null) {
            subBuffer.append("<br><font size=\"3\">").append(this.getDateFormat().format(channel.getPubDate())).append("</font>");
        }
        if (subBuffer.length() > 0) {
            buffer.append("<br>").append(subBuffer);
        }
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("</table></td></tr></table>");
    }

    protected void renderChannelItem(RssChannel channel, RssItem item, int index, int totalItems, StringBuffer buffer) {
        buffer.append("<br>");
        if (index > 0) {
            buffer.append("<hr>");
        }
        buffer.append("<table cellpadding=\"5\" cellspacing=\"0\">");
        buffer.append("<tr>");
        buffer.append("<td>");
        buffer.append("<font size=4><b>").append(item.getTitle()).append("</b></font>");
        if (item.getAuthor() != null && item.getAuthor().length() > 0) {
            buffer.append("<br>by ").append(item.getAuthor());
        }
        if (item.getPubDate() != null) {
            buffer.append("<br><i>").append(this.getDateFormat().format(item.getPubDate())).append("</i>");
        }
        if (item.getDescription() != null && item.getDescription().length() > 0) {
            if (item.getDescription().startsWith("<p>") || item.getDescription().startsWith("<P>")) {
                buffer.append(item.getDescription());
            } else {
                buffer.append("<p>").append(item.getDescription()).append("</p>");
            }
        } else {
            buffer.append("<br>");
        }
        if (item.getLink() != null) {
            buffer.append("<br><a href=\"").append(item.getLink()).append("\">").append(item.getLink()).append("</a>");
        }
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("</table>");
    }
}

