/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.rss2.rendering;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jperdian.rss2.dom.RssChannel;
import org.jperdian.rss2.dom.RssItem;

public abstract class HtmlRenderer {
    private DateFormat myDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public StringBuffer renderChannel(RssChannel channel) {
        StringBuffer buffer = new StringBuffer();
        this.renderHtmlHead(buffer);
        this.renderChannelHead(channel, buffer);
        List itemList = channel.getItemList();
        int i = 0;
        while (i < itemList.size()) {
            RssItem item = (RssItem)itemList.get(i);
            this.renderChannelItem(channel, item, i, itemList.size(), buffer);
            ++i;
        }
        this.renderChannelBottom(channel, buffer);
        this.renderHtmlBottom(buffer);
        return buffer;
    }

    public StringBuffer renderItem(RssItem item) {
        StringBuffer buffer = new StringBuffer();
        this.renderChannelHead(item.getSource(), buffer);
        this.renderChannelItem(item.getSource(), item, 0, 1, buffer);
        this.renderChannelBottom(item.getSource(), buffer);
        return buffer;
    }

    protected abstract void renderChannelHead(RssChannel var1, StringBuffer var2);

    protected abstract void renderChannelItem(RssChannel var1, RssItem var2, int var3, int var4, StringBuffer var5);

    protected void renderChannelBottom(RssChannel channel, StringBuffer buffer) {
    }

    protected void renderHtmlHead(StringBuffer buffer) {
        buffer.append("<html>");
        buffer.append("<head>");
        String styleSheet = this.createStyleSheet();
        if (styleSheet != null && styleSheet.length() > 0) {
            buffer.append("<style type=\"text/css\">");
            buffer.append(styleSheet);
            buffer.append("</style>");
        }
        buffer.append("</head>");
        buffer.append("<body>");
    }

    protected void renderHtmlBottom(StringBuffer buffer) {
        buffer.append("</body>");
        buffer.append("</html>");
    }

    public String createStyleSheet() {
        return null;
    }

    protected void setDateFormat(DateFormat format) {
        this.myDateFormat = format;
    }

    protected DateFormat getDateFormat() {
        return this.myDateFormat;
    }
}

