/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.swing.tools;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String myDescription = null;
    private String[] myExtensions = null;

    public ExtensionFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public ExtensionFileFilter(String[] extensions, String description) {
        StringBuffer newDescription = new StringBuffer(description);
        newDescription.append(" (");
        int i = 0;
        while (i < extensions.length) {
            if (i > 0) {
                newDescription.append(", ");
            }
            newDescription.append("*.").append(extensions[i]);
            ++i;
        }
        newDescription.append(")");
        this.setExtensions(extensions);
        this.setDescription(newDescription.toString());
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fileName = f.getName();
        int i = 0;
        while (i < this.getExtensions().length) {
            if (f.getName().endsWith(this.getExtensions()[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setDescription(String text) {
        this.myDescription = text;
    }

    public String getDescription() {
        return this.myDescription;
    }

    private void setExtensions(String[] extensions) {
        this.myExtensions = extensions;
    }

    private String[] getExtensions() {
        return this.myExtensions;
    }
}

