/*
 * Decompiled with CFR 0.152.
 */
package org.jperdian.swing.tools;

import java.awt.Component;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;

public class SwingHelper {
    private static final Component DUMMY_COMPONENT = new Label();
    static /* synthetic */ Class class$0;

    public static ImageIcon loadIconResource(String resourcePath) {
        Image image = SwingHelper.loadImageResource(resourcePath);
        return image == null ? null : new ImageIcon(image);
    }

    public static Image loadImageResource(String resourcePath) {
        URL resourceURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.jperdian.swing.tools.SwingHelper;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resourceURL = clazz.getClassLoader().getResource(resourcePath)) == null) {
            return null;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(resourceURL);
        MediaTracker tracker = new MediaTracker(DUMMY_COMPONENT);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return img;
    }

    public static JButton createButton(Action action) {
        return SwingHelper.createButton(action, null);
    }

    public static JButton createButton(Action action, String resourceIconPath) {
        ImageIcon icon = SwingHelper.loadIconResource(resourceIconPath);
        return SwingHelper.createButton(action, icon);
    }

    public static JButton createButton(Action action, String resourceIconPath, char shortChar) {
        ImageIcon icon = SwingHelper.loadIconResource(resourceIconPath);
        return SwingHelper.createButton(action, icon, shortChar);
    }

    public static JButton createButton(Action action, Icon icon) {
        JButton button = new JButton(action);
        if (icon != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JButton createButton(Action action, Icon icon, char shortChar) {
        JButton button = SwingHelper.createButton(action, icon);
        button.setMnemonic(shortChar);
        return button;
    }

    public static JMenuItem createMenuItem(Action action, String resourceIconPath) {
        ImageIcon icon = SwingHelper.loadIconResource(resourceIconPath);
        return SwingHelper.createMenuItem(action, icon);
    }

    public static JMenuItem createMenuItem(Action action, String resourceIconPath, char shortChar) {
        ImageIcon icon = SwingHelper.loadIconResource(resourceIconPath);
        return SwingHelper.createMenuItem(action, icon, shortChar);
    }

    public static JMenuItem createMenuItem(Action action) {
        return SwingHelper.createMenuItem(action, null);
    }

    public static JMenuItem createMenuItem(Action action, Icon icon) {
        JMenuItem menuItem = new JMenuItem(action);
        if (icon != null) {
            menuItem.setIcon(icon);
        }
        return menuItem;
    }

    public static JMenuItem createMenuItem(Action action, Icon icon, char shortChar) {
        JMenuItem menuItem = SwingHelper.createMenuItem(action, icon);
        menuItem.setMnemonic(shortChar);
        return menuItem;
    }
}

